#ifdef GL_ES
precision mediump float;

varying vec2 vTexCoord;

vec4 fragColor;
#else
in vec2 vTexCoord;
out vec4 fragColor;
#endif
uniform sampler2D colorTex;
uniform vec4 inColor;

void main()
{
#ifdef GL_ES
    float tColor = texture2D(colorTex, vTexCoord.st).r;
    gl_FragColor = vec4(tColor * inColor.rgb, inColor.a);
#else
    float tColor = texture(colorTex, vTexCoord.st).r;
    fragColor = vec4(tColor * inColor.rgb, inColor.a);
#endif
}
